%% Tract-specific analysis of ALS spinal cord data
% © Regents of the University of Minnesota.
% This software is licensed under The MIT License.  
% How to cite: If you use this software for your work, please cite the following paper published in Communications Biology: 
% Pisharady, P.K., Eberly, L.E., Cheong, I. et al. Tract-specific analysis improves sensitivity of spinal cord diffusion MRI 
% to cross-sectional and longitudinal changes in amyotrophic lateral sclerosis. Commun Biol 3, 370 (2020). https://doi.org/10.1038/s42003-020-1093-z

clear all
close all
%-- This is a manual correction applied to match the C2-C6 levels of all the subjects
lslice=[0 2 0 -3 0 3 0 5 0 1 1 2 1 2 2 -4 -2 0 2 0  1 2 0 1 1 2 1 1 1 1 0 0 2 -1 1 2 2 1 0 1]+2+4;
hslice=[25 26 25 25 25 26 25 25 22 26 26 25 26 25 26 24 25 25 24 24 25 24 25 26 25 25 23 23 26 25 25 24 25 24 24 25 25 25 24 26]+2;
exDir='/Users/pramod/CMRR/Data/ALS';
dataDir  = fullfile(exDir, 'ALS_sct');% Data directory
fileID = fopen(fullfile(exDir,'between_group_spine/Demographics_pvc.txt'));% Demographics file 
C = textscan(fileID,'%s %s %s');
fclose(fileID);
len_C=length(C{1});
con_FA=[];
pat_FA=[];
for m=1:len_C
    C{1}(m)   
%-- uncommnet below lines for whole cord     
       fileID2 = fopen(fullfile(dataDir,strcat('/',C{1}{m},'/dwi_moco_mean_cross_sectional_areas.txt')));
       dataPathC2  = textscan(fileID2,'%f %f');
       cross_area=dataPathC2{2};
      
%-- uncommnet below lines for WM or GM           
%        fileID2 = fopen(fullfile(dataDir,strcat('/',C{1}{m},'/csa_wm/csa_per_slice.txt')));  % White Matter
%        fileID2 =  fopen(fullfile(dataDir,strcat('/',C{1}{m},'/csa_gm/csa_per_slice.txt')));% Grey Matter
%        dataPathC2  = textscan(fileID2,'%s %s %s');
%        temp_string=dataPathC2{1}(5:end);
%        for i=1:length(temp_string)
%         string_split=strsplit(temp_string{i}, ',');
%         cross_area(i)=str2num(string_split{2});
%        end      

    cross_area=cross_area(lslice(m):hslice(m));
    cross_area=timewarp(cross_area,75);
    cross_area=fliplr(cross_area);
    
        if (C{3}{m}(1)=='c')
         plot(cross_area, 'Color',[0.3,.6,1],'LineWidth',.1);
         con_FA=[con_FA cross_area'];
         hold on
        else
         plot(cross_area, 'Color',[.9,.1,.3],'LineWidth',.1);
         pat_FA=[pat_FA cross_area'];
        end    
end
FA_all=[con_FA pat_FA];
diffusionFiles{1}=FA_all;
save('diffusiondata_area_WC','diffusionFiles');% The data saved here is used for further statistical analysis

meanconFA=mean(con_FA');
stdconFA=std(con_FA');
meanpatFA=mean(pat_FA');
stdpatFA=std(pat_FA');

con_FA_T=con_FA';
pat_FA_T=pat_FA';

figure
errorbar(1:length(meanconFA(1:3:end)),meanconFA(1:3:end),zeros(1,length(meanconFA(1:3:end))),stdconFA(1:3:end),'Color',[0.3,.6,1],'LineWidth',1)
hold on
errorbar(1:length(meanpatFA(1:3:end)),meanpatFA(1:3:end),stdpatFA(1:3:end),zeros(1,length(meanconFA(1:3:end))),'Color',[.9,.1,.3],'LineWidth',1);
%legend('Control','ALS');
xlim([0 26])
grid on
xlabel('Position along tract (C2-C6)','FontSize',14,'Color','k');
ylabel('Cross-sectional Area (mm^2)','FontSize',14,'Color','k'); % RD (mm^2/s)


figure
boxplot(con_FA_T(:,1:3:end),'Color',[0.3,.6,1],'PlotStyle','compact','BoxStyle','outline','Widths',.3);
hold on
boxplot(pat_FA_T(:,1:3:end),'Color',[.9,.1,.3],'PlotStyle','compact','BoxStyle','outline','Widths',.3);
xlim([0 26])
%legend('Control','ALS');
grid on
xlabel('Position along tract (C2-C6)','FontSize',14,'Color','k');
ylabel('Cross-sectional Area (mm^2)','FontSize',14,'Color','k');
title('Whole cord CSA','FontSize',16,'Color','k');

mean_along_tract_pat=mean(pat_FA)';
fa_all=mean_along_tract_pat;
fa_C2=mean(pat_FA(1:15,:))';
fa_C3=mean(pat_FA(16:30,:))';
fa_C4=mean(pat_FA(31:45,:))';
fa_C5=mean(pat_FA(46:60,:))';
fa_C6=mean(pat_FA(61:end,:))';
save('meanAreas','fa_all','fa_C6','fa_C5','fa_C4','fa_C3','fa_C2');% This data is used for the correlation analysis